// heap.java
// demonstracja sterty
// aby uruchomi program: C:>java HeapApp (wersja angielska)
// aby skompilowa wersj polsk: C:>javac heap.java
// po kompilacji:         C:>java HeapApp
import java.io.*;
////////////////////////////////////////////////////////////////
class Node
   {
   private int iData;             // element danych (klucz)
// -------------------------------------------------------------
   public Node(int key)           // konstruktor
      { iData = key; }
// -------------------------------------------------------------
   public int getKey()
      { return iData; }
// -------------------------------------------------------------
   public void setKey(int id)
      { iData = id; }
// -------------------------------------------------------------
   }  // end class Node
////////////////////////////////////////////////////////////////
class Heap
   {
   private Node[] heapArray;
   private int maxSize;           // rozmiar tablicy
   private int currentSize;       // liczba wzw w tablicy
// -------------------------------------------------------------
   public Heap(int mx)            // konstruktor
      {
      maxSize = mx;
      currentSize = 0;
      heapArray = new Node[maxSize];  // utwrz tablic
      }
// -------------------------------------------------------------
   public boolean isEmpty()
      { return currentSize==0; }
// -------------------------------------------------------------
   public boolean insert(int key)
      {
      if(currentSize==maxSize)
         return false;
      Node newNode = new Node(key);
      heapArray[currentSize] = newNode;
      trickleUp(currentSize++);
      return true;
      }  // end insert()
// -------------------------------------------------------------
   public void trickleUp(int index)
      {
      int parent = (index-1) / 2;
      Node bottom = heapArray[index];

      while( index > 0 &&
             heapArray[parent].getKey() < bottom.getKey() )
         {
         heapArray[index] = heapArray[parent];  // przenie w d
         index = parent;
         parent = (parent-1) / 2;
         }  // end while
      heapArray[index] = bottom;
      }  // end trickleUp()
// -------------------------------------------------------------
   public Node remove()           // usu element o najwyszej wartoci klucza
      {                           // (zakadamy, e lista nie jest pusta)
      Node root = heapArray[0];
      heapArray[0] = heapArray[--currentSize];
      trickleDown(0);
      return root;
      }  // end remove()
// -------------------------------------------------------------
   public void trickleDown(int index)
      {
      int largerChild;
      Node top = heapArray[index];       // zapisz korze
      while(index < currentSize/2)       // dopki wze ma co najmniej
         {                               //    jednego potomka,
         int leftChild = 2*index+1;
         int rightChild = leftChild+1;
                                         // znajd wikszego potomka
         if(rightChild < currentSize &&  // (czy prawy potomek istnieje?)
                             heapArray[leftChild].getKey() <
                             heapArray[rightChild].getKey())
            largerChild = rightChild;
         else
            largerChild = leftChild;
                                         // top >= largerChild?
         if( top.getKey() >= heapArray[largerChild].getKey() )
            break;
                                         // przesu potomka w gr
         heapArray[index] = heapArray[largerChild];
         index = largerChild;            // przejd w d
         }  // end while
      heapArray[index] = top;            // korze na pozycj 'index'
      }  // end trickleDown()
// -------------------------------------------------------------
   public boolean change(int index, int newValue)
      {
      if(index<0 || index>=currentSize)
         return false;
      int oldValue = heapArray[index].getKey(); // zapamitaj star warto
      heapArray[index].setKey(newValue);  // zmie na now warto

      if(oldValue < newValue)             // jeeli warto wzrosa,
         trickleUp(index);                // podnie wze
      else                                // jeeli zostaa zmniejszona,
         trickleDown(index);              // opu wze
      return true;
      }  // end change()
// -------------------------------------------------------------
   public void displayHeap()
      {
      System.out.print("Tablica sterty: ");    // jako tablic
      for(int m=0; m<currentSize; m++)
         if(heapArray[m] != null)
            System.out.print( heapArray[m].getKey() + " ");
         else
            System.out.print( "-- ");
      System.out.println();
                                          // jako stert
      int nBlanks = 32;
      int itemsPerRow = 1;
      int column = 0;
      int j = 0;                          // biecy element
      String dots = "...............................";
      System.out.println(dots+dots);      // grna linia kropkowana

      while(currentSize > 0)              // dla kadego elementu sterty
         {
         if(column == 0)                  // pierwszy element w wierszu?
            for(int k=0; k<nBlanks; k++)  // poprzedzajce znaki odstpu
               System.out.print(' ');
                                          // wywietl element
         System.out.print(heapArray[j].getKey());

         if(++j == currentSize)           // zakoczone?
            break;

         if(++column==itemsPerRow)        // koniec wiersza?
            {
            nBlanks /= 2;                 // poowa znakw odstpu
            itemsPerRow *= 2;             // dwa razy wiksza liczba elementw
            column = 0;                   // rozpoczynamy od nowa
            System.out.println();         //    w nastpnym wierszu
            }
         else                             // nastpny element w wierszu
            for(int k=0; k<nBlanks*2-2; k++)
               System.out.print(' ');     // znaki odstpu midzy elementami
         }  // end for
      System.out.println("\n"+dots+dots); // dolna linia kropkowana
      }  // end displayHeap()
// -------------------------------------------------------------
   }  // end class Heap
////////////////////////////////////////////////////////////////
class HeapApp
   {
   public static void main(String[] args) throws IOException
      {
      int value, value2;
      Heap theHeap = new Heap(31);  // utwrz stert; rozmiar dopuszczalny 31
      boolean success;

      theHeap.insert(70);           // wstaw 10 elementw
      theHeap.insert(40);
      theHeap.insert(50);
      theHeap.insert(20);
      theHeap.insert(60);
      theHeap.insert(100);
      theHeap.insert(80);
      theHeap.insert(30);
      theHeap.insert(10);
      theHeap.insert(90);

      while(true)                   // do wcinicia [Ctrl]-[C]
         {
         System.out.print("Wprowad pierwsz liter  ");
         System.out.print("Poka, Wstaw, Usu, Zmie: ");
         int choice = getChar();
         switch(choice)
            {
            case 'p':                        // poka
               theHeap.displayHeap();
               break;
            case 'w':                        // wstaw
               System.out.print("Wprowad warto: ");
               value = getInt();
               success = theHeap.insert(value);
               if( !success )
                  System.out.println("Nie mona wstawi nowego elementu; sterta jest pena");
               break;
            case 'u':                        // usu
               if( !theHeap.isEmpty() )
                  theHeap.remove();
               else
                  System.out.println("Nie mona usun elementu; sterta jest pusta");
               break;
            case 'z':                        // zmie
               System.out.print("Wprowad biecy indeks elementu: ");
               value = getInt();
               System.out.print("Wprowad now warto klucza: ");
               value2 = getInt();
               success = theHeap.change(value, value2);
               if( !success )
                  System.out.println("Bdna warto indeksu");
               break;
            default:
               System.out.println("Wcisne niewaciwy klawisz\n");
            }  // end switch
         }  // end while
      }  // end main()
//-------------------------------------------------------------
   public static String getString() throws IOException
      {
      InputStreamReader isr = new InputStreamReader(System.in);
      BufferedReader br = new BufferedReader(isr);
      String s = br.readLine();
      return s;
      }
//-------------------------------------------------------------
   public static char getChar() throws IOException
      {
      String s = getString();
      return s.charAt(0);
      }
//-------------------------------------------------------------
   public static int getInt() throws IOException
      {
      String s = getString();
      return Integer.parseInt(s);
      }
//-------------------------------------------------------------
  }  // end class HeapApp
////////////////////////////////////////////////////////////////
